<?php
// Pastikan parameter 'file' ada di URL
if (!isset($_GET['file'])) {
    http_response_code(400);
    echo "Bad Request: Parameter 'file' tidak ditemukan.";
    exit;
}

$filename = basename($_GET['file']); // Ambil nama file dari parameter

// Debugging: Tampilkan nama file
echo "Filename: $filename <br>";

// Daftar mapping nama file khusus
$specialCases = [
    'masehi' => 'masehi.jpg',
    'imlek' => 'imlek.jpg',
    'isramikraj' => 'isramikraj.jpg',
    'nyepi' => 'nyepi.jpg',
    'wafatisa' => 'wafatisa.jpg',
    'wafatyesus' => 'wafatyesus.jpg',
    'buruh' => 'buruh.jpg',
    'kenaikanisa' => 'kenaikanisa.jpg',
    'kenaikanyesus' => 'kenaikanyesus.jpg',
    'waisak' => 'waisak.jpg',
    'pancasila' => 'pancasila.jpg',
    'idulfitri' => 'idulfitri.jpg',
    'iduladha' => 'iduladha.jpg',
    'hijriah' => 'hijriah.jpg',
    'hutri' => 'hutri.jpg',
    'maulid' => 'maulid.jpg',
    'natal' => 'natal.jpg',
    'sabtu' => 'sabtu.jpg',
    'minggu' => 'minggu.jpg'
];

// Periksa apakah format nama file sesuai dengan YYYYMMDD*.jpg
if (preg_match('/^(\d{4})(\d{2})(\d{2})([a-z]*)\.jpg$/', $filename, $matches)) {
    $year = $matches[1];
    $month = $matches[2];
    $day = $matches[3];
    $suffix = $matches[4]; // Ambil bagian setelah tanggal jika ada

    echo "Parsed Date: $year-$month-$day <br>";
    echo "Suffix: $suffix <br>";

    // Dapatkan hari dalam seminggu (1 = Senin, 7 = Minggu)
    $dayOfWeek = date('N', strtotime("$year-$month-$day"));
    echo "Day of Week: $dayOfWeek <br>";

    // Cek jika ada suffix yang cocok dalam daftar khusus
    if (!empty($suffix) && isset($specialCases[$suffix])) {
        $imagePath = $specialCases[$suffix];
    } elseif ($dayOfWeek == 6) {
        $imagePath = "sabtu.jpg";
    } elseif ($dayOfWeek == 7) {
        $imagePath = "minggu.jpg";
    } else {
        $imagePath = $filename;
    }

    echo "Image Path: $imagePath <br>";

    $fullPath = __DIR__ . "/" . $imagePath; // Path lengkap di server

    // Debugging: Periksa apakah file ada
    if (!file_exists($fullPath)) {
        http_response_code(404);
        echo "❌ Error 404: Gambar tidak ditemukan.";
        exit;
    }

    echo "✅ Gambar ditemukan! Menampilkan gambar... <br>";

    // Kosongkan output buffer sebelum mengirim header
    ob_clean();
    flush();

    // Set header gambar
    header("Content-Type: image/jpeg");
    readfile($fullPath);
    exit;
} else {
    http_response_code(400);
    echo "Bad Request: Format nama file tidak valid.";
    exit;
}
?>
