<?php
/**
 * Shortcode: Cover Update Harian dengan Load More (Urutan berdasarkan nama file & Nomor Urut)
 */
if (!defined('ABSPATH')) {
    exit;
}

function custom_cover_update_harian_shortcode($atts, $content = null) {
    $content = preg_replace('/<br\s*\/?>/i', "\n", $content);
    $image_links = array_filter(array_map('trim', explode("\n", trim($content))), function($url) {
        return filter_var($url, FILTER_VALIDATE_URL);
    });

    if (empty($image_links)) {
        return '<p>Tidak ada gambar untuk ditampilkan.</p>';
    }

    function get_indonesian_day($date) {
        $days = [
            'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];
        return $days[date('l', strtotime($date))] ?? 'Tidak Diketahui';
    }

    // Urutkan gambar berdasarkan nama file
    usort($image_links, function($a, $b) {
        return strcmp(pathinfo($a, PATHINFO_FILENAME), pathinfo($b, PATHINFO_FILENAME));
    });

    $output = '<div class="cover-update-wrapper">';
    $output .= '<div class="cover-update">';

    foreach ($image_links as $index => $src) {
        $src = str_replace(['br%20/', 'br /'], '', $src);
        $filename = pathinfo($src, PATHINFO_FILENAME);
        preg_match('/([a-zA-Z]+)(\d{8})/', $filename, $matches);

        if (!empty($matches[2])) {
            $newspaper_name = strtolower($matches[1]);
            $date_str = $matches[2];
            $formatted_date = substr($date_str, 0, 4) . '-' . substr($date_str, 4, 2) . '-' . substr($date_str, 6, 2);
            $day_name = get_indonesian_day($formatted_date);
            $caption = '<span style="display:block; font-weight:bold;">' . esc_html($newspaper_name) . '</span>' . $day_name . ' ' . substr($formatted_date, 8, 2) . '-' . substr($formatted_date, 5, 2) . '-' . substr($formatted_date, 0, 4);
        } else {
            $caption = 'Tanggal Tidak Diketahui';
        }

        $display_src = preg_replace('/\/s\d+\//', '/s300/', $src);
        $hidden_class = ($index >= 5) ? ' hidden' : '';
        $image_number = str_pad($index + 1, 3, '0', STR_PAD_LEFT);

        $output .= '<div class="cover-update-item' . $hidden_class . '">';
        $output .= '<a href="' . esc_url($src) . '" target="_blank">';
        $output .= '<div class="image-wrapper">';
        $output .= '<img src="' . esc_url($display_src) . '" alt="Cover Harian ' . ($index + 1) . '">';
        $output .= '<div class="image-number">' . $image_number . '</div>';
        $output .= '</div>';
        $output .= '</a>';
        $output .= '<p>' . $caption . '</p>';
        $output .= '</div>';
    }

    $output .= '</div>';
    if (count($image_links) > 5) {
        $output .= '<button id="loadMoreCovers">TAMPILKAN COVER LAINNYA ...</button>';
    }
    $output .= '</div>';

    $output .= '<style>
        .cover-update-wrapper {
            padding: 10px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .cover-update {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 10px;
            width: 95%;
            max-width: 1150px;
            padding: 10px;
        }
        .cover-update-item {
            text-align: center;
            overflow: hidden;
            position: relative;
        }
        .image-wrapper {
            position: relative;
        }
        .cover-update img {
            width: 100%;
            height: auto;
            object-fit: cover;
            border-radius: 10px;
            transition: transform 0.3s ease, filter 0.3s ease;
            border: 3px solid #ddd;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        }
        .cover-update img:hover {
            filter: brightness(80%);
            transform: scale(1.05);
        }
        .image-number {
            position: absolute;
            bottom: 5px;
            left: 5px;
            background: black;
            color: white;
            font-weight: bold;
            padding: 5px 8px;
            font-size: 14px;
            border-radius: 3px;
        }
        .hidden { display: none; }
        #loadMoreCovers {
            margin-top: 15px;
            padding: 10px 20px;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            transition: background-color 0.3s;
        }
        #loadMoreCovers:hover {
            background-color: #0056b3;
        }
    </style>';

    $output .= '<script>
        document.addEventListener("DOMContentLoaded", function() {
            let hiddenItems = document.querySelectorAll(".cover-update-item.hidden");
            let loadMoreButton = document.getElementById("loadMoreCovers");
            if (loadMoreButton) {
                loadMoreButton.addEventListener("click", function() {
                    hiddenItems.forEach(item => item.classList.remove("hidden"));
                    loadMoreButton.style.display = "none";
                });
            }
        });
    </script>';

    return $output;
}
add_shortcode('cover_update_harian', 'custom_cover_update_harian_shortcode');