<?php
/**
 * Plugin Name: No Comments Forever
 * Description: Menonaktifkan semua komentar & trackback di seluruh website WordPress (termasuk REST API & wp-comments-post.php).
 * Version: 1.0
 * Author: griyatokoonline.com
 */

// Pastikan langsung exit kalau dipanggil di luar WordPress
if (!defined('ABSPATH')) {
    exit;
}

// -------------------------
// 1. Disable form & data komentar
// -------------------------
add_filter('comments_open', '__return_false', 20, 2);
add_filter('pings_open', '__return_false', 20, 2);
add_filter('comments_array', '__return_empty_array', 10, 2);

// -------------------------
// 2. Blokir akses langsung ke wp-comments-post.php
// -------------------------
function nocomments_block_comment_post() {
    if (strpos($_SERVER['REQUEST_URI'], 'wp-comments-post.php') !== false) {
        wp_die('Komentar dimatikan permanen.', 'Komentar Dinonaktifkan', ['response' => 403]);
    }
}
add_action('init', 'nocomments_block_comment_post');

// -------------------------
// 3. Hilangkan menu Komentar di Dashboard
// -------------------------
function nocomments_remove_admin_menus() {
    remove_menu_page('edit-comments.php');
}
add_action('admin_menu', 'nocomments_remove_admin_menus');

// -------------------------
// 4. Redirect kalau ada user yang coba buka halaman komentar di admin
// -------------------------
function nocomments_admin_redirect() {
    global $pagenow;
    if ($pagenow === 'edit-comments.php' || $pagenow === 'comment.php') {
        wp_safe_redirect(admin_url()); 
        exit;
    }
}
add_action('admin_init', 'nocomments_admin_redirect');

// -------------------------
// 5. Tutup endpoint REST API untuk komentar
// -------------------------
add_filter('rest_endpoints', function($endpoints) {
    if (isset($endpoints['/wp/v2/comments'])) {
        unset($endpoints['/wp/v2/comments']);
    }
    return $endpoints;
});
