<?php
/*
Plugin Name: Disable Automatic Image Crop
Author: Wordpress Community
Description: wpse124009 - http://wordpress.stackexchange.com/questions/124009/why-wordpress-automatic-cropping-all-my-images and https://developer.wordpress.org/reference/functions/remove_image_size/
*/

add_action( 'init', 'czc_disable_extra_image_sizes' );
add_filter( 'image_resize_dimensions', 'czc_disable_crop', 10, 6 );

function czc_disable_crop( $enable, $orig_w, $orig_h, $dest_w, $dest_h, $crop )
{
    // Instantly disable this filter after the first run
    // remove_filter( current_filter(), __FUNCTION__ );
    // return image_resize_dimensions( $orig_w, $orig_h, $dest_w, $dest_h, false );
    return false;
}

function czc_disable_extra_image_sizes() {
    foreach ( get_intermediate_image_sizes() as $size ) {
        remove_image_size( $size );
    }
}
?>