<?php
/**
* The template for displaying tag archive pages with sorting functionality.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package GridMe WordPress Theme
* @copyright Copyright (C) 2023 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

get_header(); ?>

<div class="gridme-main-wrapper gridme-clearfix" id="gridme-main-wrapper" itemscope="itemscope" itemtype="http://schema.org/Blog" role="main">
<div class="theiaStickySidebar">
<div class="gridme-main-wrapper-inside gridme-clearfix">

<?php gridme_before_main_content(); ?>

<div class="gridme-posts-wrapper" id="gridme-posts-wrapper">

<div class="gridme-page-header-outside">
<header class="gridme-page-header">
<div class="gridme-page-header-inside">
<h1 class="page-title"><?php single_tag_title('Surat Kabar: '); ?></h1>
<?php the_archive_description('<div class="taxonomy-description">', '</div>'); ?>
</div>
</header>
</div>

<!-- Dropdown Sort By -->
<form method="GET" style="margin-bottom: 20px;">
    <label for="sortby">Sort By:</label>
    <select name="sortby" id="sortby">
        <option value="date" <?php selected($_GET['sortby'] ?? '', 'date'); ?>>Post Date</option>
        <option value="title" <?php selected($_GET['sortby'] ?? '', 'title'); ?>>Title</option>
    </select>

    <label for="order">Order:</label>
    <select name="order" id="order">
        <option value="DESC" <?php selected($_GET['order'] ?? '', 'DESC'); ?>>Descending</option>
        <option value="ASC" <?php selected($_GET['order'] ?? '', 'ASC'); ?>>Ascending</option>
    </select>

    <button type="submit">Sort</button>
</form>

<div class="gridme-posts-content">

<?php
// Setup sorting parameters
$sortby = $_GET['sortby'] ?? 'date';
$order = $_GET['order'] ?? 'DESC';

// Validasi input untuk keamanan
$allowed_sortby = ['date', 'title'];
$allowed_order = ['ASC', 'DESC'];

if (!in_array($sortby, $allowed_sortby)) {
    $sortby = 'date';
}
if (!in_array($order, $allowed_order)) {
    $order = 'DESC';
}

// Custom Query untuk Sorting
$paged = get_query_var('paged') ? get_query_var('paged') : 1;
$args = [
    'tag' => get_query_var('tag'),
    'orderby' => $sortby,
    'order' => $order,
    'paged' => $paged,
];

$query = new WP_Query($args);

if ($query->have_posts()) : ?>

    <div class="gridme-posts gridme-posts-grid">
    <?php while ($query->have_posts()) : $query->the_post(); ?>

        <?php get_template_part('template-parts/content-grid'); ?>

    <?php endwhile; ?>
    </div>
    <div class="clear"></div>

    <?php
    // Pagination
    gridme_posts_navigation();
    ?>

    <?php wp_reset_postdata(); ?>

<?php else : ?>

    <?php get_template_part('template-parts/content', 'none'); ?>

<?php endif; ?>

</div>

</div><!--/#gridme-posts-wrapper -->

<?php gridme_after_main_content(); ?>

</div>
</div>
</div><!-- /#gridme-main-wrapper -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
