<?php
/**
* Other options
*
* @package GridMe WordPress Theme
* @copyright Copyright (C) 2023 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

function gridme_other_options($wp_customize) {

    $wp_customize->add_section( 'gridme_section_other_options', array( 'title' => esc_html__( 'Other Options', 'gridme' ), 'panel' => 'gridme_main_options_panel', 'priority' => 600 ) );

    $wp_customize->add_setting( 'gridme_options[enable_widgets_block_editor]', array( 'default' => false, 'type' => 'option', 'capability' => 'edit_theme_options', 'sanitize_callback' => 'gridme_sanitize_checkbox', ) );

    $wp_customize->add_control( 'gridme_enable_widgets_block_editor_control', array( 'label' => esc_html__( 'Enable Gutenberg Widget Block Editor', 'gridme' ), 'section' => 'gridme_section_other_options', 'settings' => 'gridme_options[enable_widgets_block_editor]', 'type' => 'checkbox', ) );

    $wp_customize->add_setting( 'gridme_options[disable_loading_animation]', array( 'default' => false, 'type' => 'option', 'capability' => 'edit_theme_options', 'sanitize_callback' => 'gridme_sanitize_checkbox', ) );

    $wp_customize->add_control( 'gridme_disable_loading_animation_control', array( 'label' => esc_html__( 'Disable Site Loading Animation', 'gridme' ), 'section' => 'gridme_section_other_options', 'settings' => 'gridme_options[disable_loading_animation]', 'type' => 'checkbox', ) );

    $wp_customize->add_setting( 'gridme_options[disable_fitvids]', array( 'default' => false, 'type' => 'option', 'capability' => 'edit_theme_options', 'sanitize_callback' => 'gridme_sanitize_checkbox', ) );

    $wp_customize->add_control( 'gridme_disable_fitvids_control', array( 'label' => esc_html__( 'Disable FitVids.JS', 'gridme' ), 'description' => esc_html__( 'You can disable fitvids.js script if you are not using videos on your website or if you do not want fluid width videos in your post content.', 'gridme' ), 'section' => 'gridme_section_other_options', 'settings' => 'gridme_options[disable_fitvids]', 'type' => 'checkbox', ) );

}