<?php
/**
 * Shortcode: Image Profil Koran
 * 
 * Cara Menggunakan:
 * [kr_template image="URL_GAMBAR" nama="Nama Media" moto="Moto Media" small_text="Edisi: Rabu, 5 Maret 2025"]
 */


function kr_custom_template_shortcode($atts) {
    $atts = shortcode_atts([
        'image' => '',
        'nama' => 'KEDAULATAN RAKYAT',
        'moto' => 'AMANAT HATI NURANI RAKYAT',
        'small_text' => ''
    ], $atts, 'kr_template');

    // Pastikan URL gambar tidak kosong
    $image_url = esc_url($atts['image']);
    if (empty($image_url)) {
        $image_url = 'https://via.placeholder.com/335x500/808080/FFFFFF?text=Upload+Image'; // Background abu-abu
    }

    // Path font file
    $font_nama = 'https://arsipkoran.com/img/BigShoulders-Medium.ttf';
    $font_moto = 'Arial Narrow Bold';

    ob_start();
    ?>
    <div style="position: relative; width: 100%; max-width: 355px; margin: 0 auto 50px auto; text-align: center; display: flex; flex-direction: column; align-items: center;">
        <div style="width: 300px; height: 460px; background: url('<?php echo $image_url; ?>') no-repeat center top; background-size: contain; border: 2px solid #000; position: relative; overflow: hidden; margin-bottom: -40px; border-radius: 10px; box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.2);">
        </div>
        <div style="width: 360px; height: 100px; background: #5C3A21; border-radius: 15px 15px 0 0; position: relative; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 10px; box-shadow: 0px -5px 10px rgba(0, 0, 0, 0.3);">
            <p style="font-family: url('<?php echo esc_url($font_nama); ?>'); font-size: clamp(16px, 1.5vw, 22px); font-weight: bold; color: white; margin: 5px; text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5); text-align: center; text-decoration: underline;">
                <?php echo esc_html($atts['nama']); ?>
            </p>
            <p style="font-family: '<?php echo esc_html($font_moto); ?>'; font-size: clamp(12px, 1.2vw, 16px); color: white; margin: -10px 0 0 0; text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.5); text-align: center;">
                <?php echo esc_html($atts['moto']); ?>
            </p>
        </div>
        <?php if (!empty($atts['small_text'])) : ?>
            <p style="position: absolute; bottom: -20px; right: 5px; font-size: 12px; color: #333; font-style: italic; ">
                <?php echo esc_html($atts['small_text']); ?>
            </p>
        <?php endif; ?>
    </div>
    <style>
        @media (max-width: 600px) {
            div[style*="width: 300px"] {
                width: 280px;
                height: auto;
                max-width: 90%;
                margin-bottom: -30px;
            }
            div[style*="width: 360px"] {
                width: 330px;
                max-width: 100%;
            }
        }
    </style>
    <?php
    return ob_get_clean();
}
add_shortcode('kr_template', 'kr_custom_template_shortcode');

