<?php
// Daftar Shortcode: [kotak_teks] dan [kolom]

function kotak_teks_styles() {
    echo '<style>
        .kotak-teks {
            background-color: #f3f3f3;
            border-radius: 10px;
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 11pt;
            display: flex;
            flex-wrap: wrap;
            gap: 0px;
            margin-bottom: 20px;
        }
        .kotak-teks .kolom {
            flex: 1 1 300px;
        }
    </style>';
}
add_action('wp_head', 'kotak_teks_styles');

// Shortcode Utama: [kotak_teks]...[/kotak_teks]
function kotak_teks_shortcode($atts, $content = null) {
    return '<div class="kotak-teks">' . do_shortcode($content) . '</div>';
}
add_shortcode('kotak_teks', 'kotak_teks_shortcode');

// Shortcode Kolom: [kolom]...[/kolom]
function kolom_shortcode($atts, $content = null) {
    return '<div class="kolom">' . do_shortcode($content) . '</div>';
}
add_shortcode('kolom', 'kolom_shortcode');
