<?php
// Ambil parameter URL gambar
global $_GET;
$image_url = isset($_GET['img']) ? $_GET['img'] : '';

if (!$image_url) {
    die("No image URL provided.");
}

// Ambil nama file dari URL
$filename = basename($image_url);

// Ekstrak informasi dari nama file
if (preg_match('/(.+?)_(\d{6,8})(?:-(.+))?\.jpg/', $filename, $matches)) {
    $titleRaw = str_replace('-', ' ', ucwords($matches[1])); // Ubah setiap kata menjadi kapital
    $date = $matches[2];
    $dayName = isset($matches[3]) ? ucfirst(str_replace('-', ' ', $matches[3])) : '';
    
    // Konversi tanggal ke format yang lebih mudah dibaca
    $year = substr($date, 0, 4);
    $month = substr($date, 4, 2);
    $day = strlen($date) == 8 ? substr($date, 6, 2) : '';
    
    $months = [
        "01" => "Januari", "02" => "Februari", "03" => "Maret", "04" => "April",
        "05" => "Mei", "06" => "Juni", "07" => "Juli", "08" => "Agustus",
        "09" => "September", "10" => "Oktober", "11" => "November", "12" => "Desember"
    ];
    
    if ($day) {
        $formatted_date = "$dayName, $day {$months[$month]} $year";
    } else {
        $formatted_date = "Edisi {$months[$month]} $year";
    }
    
    // Pecah title menjadi beberapa baris sesuai jumlah kata
    $titleParts = explode(' ', $titleRaw);
    $textLines = $titleParts;
    $text4 = "$formatted_date";
} else {
    $textLines = ["Media", "Indonesia"];
    $text4 = "";
}

// Buat gambar baru dengan ukuran yang diinginkan
$width = 335;
$height = 535;
$image = imagecreatetruecolor($width, $height);

// Tentukan background berdasarkan hari
if (strtolower($dayName) === "minggu") {
    $bg_top = imagecolorallocate($image, 220, 100, 100); // Merah terang
    $bg_bottom = imagecolorallocate($image, 180, 50, 50); // Merah gelap
    $textColor = imagecolorallocate($image, 255, 255, 255); // Putih
} else {
    $bg_top = imagecolorallocate($image, 150, 220, 180); // Hijau terang
    $bg_bottom = imagecolorallocate($image, 90, 160, 120); // Hijau gelap
    $textColor = imagecolorallocate($image, 0, 0, 0); // Hitam
}

// Hitung tinggi area title secara fleksibel
$titleFontSize = 34; // Ukuran diperbesar 20%
$titleSpacing = 40; // Jarak antar baris
$titleHeight = count($textLines) * $titleSpacing + 50;
$titleHeight = min($titleHeight, 200); // Batasi tinggi maksimum agar tidak terlalu besar

// Buat background title dengan tinggi fleksibel
imagefilledrectangle($image, 0, 0, $width, $titleHeight, $bg_top);
imagefilledrectangle($image, 0, $titleHeight, $width, $height, $bg_bottom);

// Tambahkan teks ke gambar
$font_literata = __DIR__ . '/Literata-BlackItalic.ttf';
$font_bigshoulders = __DIR__ . '/BigShoulders-Medium.ttf';

if (file_exists($font_literata) && file_exists($font_bigshoulders)) {
    // Posisi Title
    $y = 40;
    foreach ($textLines as $line) {
        imagettftext($image, $titleFontSize, 0, 20, $y, $textColor, $font_literata, $line);
        $y += $titleSpacing;
    }
    // Posisi Date dipindah ke area bawah
    imagettftext($image, 20, 0, 20, $height - 30, $textColor, $font_bigshoulders, $text4);
} else {
    $y = 40;
    foreach ($textLines as $line) {
        imagestring($image, 5, 20, $y, $line, $textColor);
        $y += 30;
    }
    imagestring($image, 4, 20, $height - 30, $text4, $textColor);
}

// Output gambar
header("Content-Type: image/png");
imagepng($image);
imagedestroy($image);
?>
