<?php
/*
Shortcode: [page_index exclude="ID1,ID2"]
Deskripsi:
Shortcode ini akan menampilkan daftar halaman yang diurutkan berdasarkan abjad.
Halaman dengan huruf awal yang sama akan dikelompokkan dan ditampilkan dalam grid.

Parameter:
- exclude: (opsional) ID halaman yang ingin dikecualikan, dipisahkan dengan koma.
  Contoh: [page_index exclude="12,45,78"] untuk mengecualikan halaman dengan ID 12, 45, dan 78.
*/

function custom_page_index_shortcode($atts) {
    $atts = shortcode_atts(array(
        'exclude' => '',
    ), $atts, 'page_index');

    $exclude_ids = (!empty($atts['exclude'])) ? explode(',', $atts['exclude']) : array();

    // Query untuk mengambil halaman
    $args = array(
        'post_type'      => 'page',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        'post__not_in'   => $exclude_ids,
    );

    $pages = new WP_Query($args);
    $output = '';

    if ($pages->have_posts()) {
        $grouped_pages = [];

        while ($pages->have_posts()) {
            $pages->the_post();
            $title = get_the_title();
            $first_letter = strtoupper(mb_substr($title, 0, 1));

            if (is_numeric($first_letter)) {
                $first_letter = '0-9';
            }

            $grouped_pages[$first_letter][] = '<div class="page-item"><a href="' . get_permalink() . '">' . $title . '</a></div>';
        }

        ksort($grouped_pages);

        // Grid berbentuk tabel untuk alfabet
        $output .= '<div class="custom-page-index">';
        foreach ($grouped_pages as $letter => $pages_list) {
            $output .= '<div class="page-section">';
            $output .= '<h2 class="page-header">' . esc_html($letter) . '</h2>';
            $output .= '<div class="separator"></div>'; // Garis merah pemisah alfabet
            $output .= '<div class="page-list">' . implode('<div class="item-separator"></div>', $pages_list) . '</div>';
            $output .= '</div>';
        }
        $output .= '</div>';
    } else {
        $output .= '<p>Tidak ada halaman yang tersedia.</p>';
    }

    wp_reset_postdata();
    return $output;
}
add_shortcode('page_index', 'custom_page_index_shortcode');

// Tambahkan CSS agar tampilan sesuai permintaan
function custom_page_index_styles() {
    echo '<style>
        .custom-page-index {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            padding: 10px;
        }
        .page-section {
            flex: 1 1 calc(25% - 15px);
            background: #fff;
            padding: 10px;
            border-radius: 5px;
            transition: all 0.3s ease-in-out;
            box-shadow: 0px 0px 3px rgba(0, 0, 0, 0.1);
            min-width: 200px;
        }
        .page-header {
            font-size: 18px;
            font-weight: bold;
            color: #d33;
            display: inline-block;
            margin-bottom: 5px;
        }
        .separator {
            width: 100%;
            height: 3px;
            background: #d33;
            margin-bottom: 10px;
        }
        .page-list {
            display: flex;
            flex-direction: column;
        }
        .page-item {
            padding: 5px 0;
        }
        .page-item a {
            text-decoration: none !important;
            font-weight: normal;
            color: #333;
            display: block;
            transition: color 0.3s ease-in-out, text-decoration 0.3s ease-in-out;
        }
        .page-item a:hover {
            color: #d33;
            text-decoration: underline;
        }
        .item-separator {
            width: 100%;
            height: 1px;
            background: #ddd;
            margin: 3px 0;
        }
        @media (max-width: 768px) {
            .page-section {
                flex: 1 1 calc(50% - 15px);
            }
        }
        @media (max-width: 480px) {
            .page-section {
                flex: 1 1 100%;
            }
        }
    </style>';
}
add_action('wp_head', 'custom_page_index_styles');
