<?php
/**
 * Shortcode: [tabel_koran] untuk menampilkan tabel arsip koran.
 *
 * Cara Penggunaan:
 * [tabel_koran]
 * Media 202407
 * 20240701: Edisi Senin
 * 20240702: Edisi Selasa
 * [/tabel_koran]
 *
 * Baris pertama harus berisi nama media dan tahun+bulan dalam format YYYYMM.
 * Baris berikutnya adalah daftar tanggal dengan format YYYYMMDD: Deskripsi.
 */

function tabel_koran_shortcode($atts, $content = null) {
    if (!$content) return '<p style="color:red;">Tidak ada data di dalam shortcode.</p>';

    $lines = array_filter(array_map(fn($line) => strip_tags(trim($line)), explode("\n", trim($content))));

    do {
        $first_line = strip_tags(trim(array_shift($lines)));
    } while ($first_line === '' || $first_line === null);

    if (!preg_match('/^(.+)\s(\d{6})$/', $first_line, $matches)) {
        return '<p style="color:red;">Format judul tidak valid.</p>';
    }

    $media = ucwords(strtolower($matches[1]));
    $tahun = substr($matches[2], 0, 4);
    $bulan = substr($matches[2], 4, 2);

    $bulan_nama = [
        '01' => 'Januari', '02' => 'Februari', '03' => 'Maret',
        '04' => 'April', '05' => 'Mei', '06' => 'Juni',
        '07' => 'Juli', '08' => 'Agustus', '09' => 'September',
        '10' => 'Oktober', '11' => 'November', '12' => 'Desember'
    ];

    $judul = "Daftar Arsip $media Edisi {$bulan_nama[$bulan]} $tahun";
    $hari_id = ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'];
    $data = [];

    foreach ($lines as $line) {
        if (preg_match('/^(\d{8}):\s*(.*)$/', $line, $matches)) {
            $tanggal = $matches[1];
            $keterangan = !empty($matches[2]) ? $matches[2] : '-';

            $tahun = substr($tanggal, 0, 4);
            $bulan = substr($tanggal, 4, 2);
            $hari = substr($tanggal, 6, 2);

            $timestamp = strtotime("$tahun-$bulan-$hari");
            $hari_text = $hari_id[date('w', $timestamp)];
            $tanggal_format = "$hari_text, $hari " . $bulan_nama[$bulan] . " $tahun";

            $data[] = "<tr><td>$tanggal_format</td><td>$keterangan</td></tr>";
        }
    }

    return "<div class='judul-container'><div class='judul-wrapper'><span class='judul-line'></span> $judul <span class='judul-line'></span></div></div>
    <div class='tabel-arsip-container'>
        <div class='tabel-arsip-wrapper'>
            <table class='tabel-arsip'>
                <tr><th>EDISI</th><th>KETERSEDIAAN ARSIP</th></tr>" . implode('', $data) . "</table>
        </div>
    </div>
    <style>
        .judul-container {
            text-align: center;
            margin-top: 70px;
        }
        .judul-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            font-size: 1.8em;
            font-weight: bold;
        }
        .judul-line {
            display: inline-block;
            height: 2px;
            background-color: #888;
            min-width: 120px;
            flex-grow: 1;
        }
        .tabel-arsip-container {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .tabel-arsip {
            border-collapse: collapse;
            width: auto;
            text-align: left;
            font-size: 1em;
        }
        .tabel-arsip th, .tabel-arsip td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        .tabel-arsip th {
            background-color: #f2f2f2;
            text-align: center;
        }
    </style>";
}
add_shortcode('tabel_koran', 'tabel_koran_shortcode');
